/****************************************************************************************/
/**
  Copyright (c) 2008 Freescale Semiconductor
  Freescale Confidential Proprietary
  \file     	Pit.h
  \brief    	This file contains all Pit functions and definition declarations. 
  \author   	Freescale Semiconductor
  \author     r01160
  \author   	Guadalajara Applications Laboratory RTAC Americas
  \version    0.1
  \date     	5/23/2008 
  \warning      
  
  * History:
  
*/
/****************************************************************************************/
#ifndef _PIT_H_
  #define _PIT_H_
  
  #include "Port.h"
  #include "Derivative.h"
  #include "Scheduler.h"
  #include "Pwm.h"
    
/*------------------------- Type definitions --------------------------------------------------------------*/    
 typedef void(*Pit_CallbackType)(void);
    
/*--------------------- Macros --------------------------*/
/** Assign Counter value to desired Pit channel. Violates MISRA 2004 rule 11.3 and 14.3 because addressing memory mapped registers */
#define PIT_LOAD_VALUE(u8Pit_Ch, u32Val)        \
{                                               \
    switch(u8Pit_Ch)                            \
    {                                           \
       case 0:  PIT_TLVAL0 = (uint32_t)u32Val;  \
           break;                               \
       case 1:  PIT_TLVAL1 = (uint32_t)u32Val;  \
           break;                               \
       case 2:  PIT_TLVAL2 = (uint32_t)u32Val;  \
           break;                               \
       case 3:  PIT_TLVAL3 = (uint32_t)u32Val;  \
           break;                               \
       case 4:  PIT_TLVAL4 = (uint32_t)u32Val;  \
           break;                               \
       case 5:  PIT_TLVAL5 = (uint32_t)u32Val;  \
           break;                               \
       case 6:  PIT_TLVAL6 = (uint32_t)u32Val;  \
           break;                               \
       case 7:  PIT_TLVAL7 = (uint32_t)u32Val;  \
           break;                               \
       default:                                 \
           break;                               \
    }                                           \
}


 /** Pit Channel assigned to generate Pwm timebase */
 #define PIT_CH_1         ((uint8_t)1)
 /** Pit Vector Interrupt Offset                   */
 #define PIT_BASE_OFFSET  ((uint8_t)148)
/** This macro Initiates the generation of all configured Pwm Signals */
 #define PWM_ENABLED         (PIT_EN  = (PIT_EN  | ((uint32_t)1<< (uint32_t)PIT_ASSIGNED_CHANNEL)))
 /*--------------------- Functions --------------------------*/
 void vfnPit_Init(uint8_t u8PitChannel, uint32_t u32Period);
 void vfnPit_Set_Callback_Fnc(Pit_CallbackType Callback_Fnc);
 void Pit_Pwm_Generation_Isr(void);  
 



#endif